<?php

// Hook to 'admin_menu' action to register the admin menu
add_action('admin_menu', 'caravan_builder_client_admin_menu');

function caravan_builder_client_admin_menu() {
    // This function adds a new top-level menu to the admin panel.
    add_menu_page(
        'Caravan Client Builder',
        'Caravan Client Builder Settings',
        'manage_options',
        'caravan-builder-client-settings',
        'caravan_builder_client_menu_page',
        'dashicons-admin-generic',
        7
    );
}

// Callback function to display the content of the custom menu page
function caravan_builder_client_menu_page() {
    // global $caravanBuilder;
    // Check if user has submitted the form
    if ( isset( $_POST['bcb_submit'] ) && check_admin_referer( 'bcb_save_fields' ) ) {
        $email = sanitize_email( $_POST['bcb_email'] );
        $key   = sanitize_text_field( $_POST['bcb_key'] );

        // Save to options table
        update_option( 'bcb_email', $email );
        update_option( 'bcb_key', $key );

        echo '<div class="updated"><p>Values saved successfully.</p></div>';
    }

    // Get saved values
    $saved_email = get_option( 'bcb_email', '' );
    $saved_key   = get_option( 'bcb_key', '' );
    ?>


    <div class="wrap">
        <h1><?php esc_html_e('Caravan Builder', 'textdomain'); ?></h1>
        <p><?php esc_html_e('Welcome to the caravan builder admin menu page!', 'textdomain'); ?></p>
        <p><?php esc_html_e('Please use the following shortcode `[caravan-builder]` to embed the builder.', 'textdomain'); ?></p>
        <p>
            <?php

                    ?>
                    <div id="root" class="wrap">
                        <h1>Manage your Caravan Builder settings</h1>
                        <form method="post" action="">
                            <div>Please enter the email and key for your Caravan Builder settings provided by your supplier</div>
                            <?php wp_nonce_field( 'bcb_save_fields' ); ?>
                            <table class="form-table">
                                <tr valign="top">
                                    <th scope="row"><label for="bcb_email">Email</label></th>
                                    <td><input type="email" id="bcb_email" name="bcb_email" value="<?php echo esc_attr( $saved_email ); ?>" required style="width: 300px;"></td>
                                </tr>
                                <tr valign="top">
                                    <th scope="row"><label for="bcb_key">Key</label></th>
                                    <td><input type="text" id="bcb_key" name="bcb_key" value="<?php echo esc_attr( $saved_key ); ?>" required style="width: 300px;"></td>
                                </tr>
                            </table>
                            <p class="submit">
                                <input type="submit" name="bcb_submit" class="button-primary" value="Save Changes">
                            </p>
                        </form>
                    </div>
                    <?php
            ?>
        </p>

    </div>
    <?php
}