<?php
add_action('admin_enqueue_scripts', 'enqueue_react_app');

function enqueue_react_app($hook) {
    // Check if we're on the specific admin page to avoid loading it unnecessarily
    if ($hook !== 'toplevel_page_caravan-builder-super-admin-settings') {
        return;
    }

    // Path to the build directory
    $build_dir = plugin_dir_path(__FILE__) . '../../../assets/';
    $build_dir_img = plugin_dir_path(__FILE__) . '../../../assets/images';
    
    // Load the manifest file
    $manifest_file = $build_dir . 'asset-manifest.json';
    if (file_exists($manifest_file)) {
        $manifest = json_decode(file_get_contents($manifest_file), true);

        // print_r($manifest); die;

        wp_enqueue_media();
        // Enqueue the main JS file
        if (!empty($manifest['files']['main.js'])) {
            wp_enqueue_script('caravan-react-app', plugins_url('../../../assets/' . $manifest['files']['main.js'], __FILE__), array(), null, true);
        }

        // Enqueue the main CSS file
        if (!empty($manifest['files']['main.css'])) {
            wp_enqueue_style('caravan-react-app', plugins_url('../../../assets/' . $manifest['files']['main.css'], __FILE__));
        }
        
        // Enqueue any additional chunk files (like 453.28a215d1.chunk.js)
        if (!empty($manifest['files']['runtime-main.js'])) {
            wp_enqueue_script('caravan-react-runtime', plugins_url('../../../assets/' . $manifest['files']['runtime-main.js'], __FILE__), array(), null, true);
        }
        foreach ($manifest['files'] as $file => $path) {
            if (strpos($file, 'chunk.js') !== false) {
                wp_enqueue_script('caravan-react-chunk-' . $file, plugins_url('../../../assets/' . $path, __FILE__), array(), null, true);
            }
        }

        // Localize data for your React app
        wp_localize_script('caravan-react-app', 'myAppData', array(
            'imagesUrl' => plugin_dir_url( $build_dir_img), 
        ));
    }
}