<?php

function enqueue_super_admin_fe_react_app() {
    // Path to the build directory
    $build_dir = plugin_dir_path(__FILE__) . '../../../frontend/';
    
    // Load the manifest file
    $manifest_file = $build_dir . 'asset-manifest.json';
    // print_r($manifest_file); die;
    if (file_exists($manifest_file)) {
        $manifest = json_decode(file_get_contents($manifest_file), true);

        // Enqueue the main JS file
        if (!empty($manifest['files']['main.js'])) {
            wp_enqueue_script('caravan-super-admin-react-fe-app', plugins_url('../../../frontend/' . $manifest['files']['main.js'], __FILE__), array(), null, true);
        }

        // Enqueue the main CSS file
        if (!empty($manifest['files']['main.css'])) {
            wp_enqueue_style('caravan-super-admin-react-fe-app', plugins_url('../../../frontend/' . $manifest['files']['main.css'], __FILE__));
        }
        
        // Enqueue any additional chunk files (like 453.28a215d1.chunk.js)
        if (!empty($manifest['files']['runtime-main.js'])) {
            wp_enqueue_script('caravan-super-admin-react-fe-runtime', plugins_url('../../../frontend/' . $manifest['files']['runtime-main.js'], __FILE__), array(), null, true);
        }
        foreach ($manifest['files'] as $file => $path) {
            if (strpos($file, 'chunk.js') !== false) {
                wp_enqueue_script('caravan-super-admin-react-fe-chunk-' . $file, plugins_url('../../../frontend/' . $path, __FILE__), array(), null, true);
            }
        }
    }
}

// Function that outputs the shortcode content
function bitsia_super_admin_caravan_builder_shortcode($atts) {
    // Set default attributes
    $atts = shortcode_atts(
        array(
            'id' => 'default',
        ),
        $atts,
        'caravan-super-admin-builder'
    );

    // Enqueue the React app assets
    enqueue_super_admin_fe_react_app();

    // Return the output
    return '
        <div class="bitsia-caravan-builder-plugin">
            <div id="root" class="wrap"></div>
        </div>
    ';
}

// Register the shortcode
add_shortcode('caravan-super-admin-builder', 'bitsia_super_admin_caravan_builder_shortcode');
