<?php
/**
 * @package Joomla 1.5.x
 * @copyright	Copyright (C) 2005 - 2010 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant to the
 * GNU General Public License, and as distributed it includes or is derivative
 * of works licensed under the GNU General Public License or other free or open
 * source software licenses. See COPYRIGHT.php for copyright notices and
 * details.
 *
 * @component Tecox
 * @copyright Copyright (C) 2010 by www.teglo.info
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @date $Date: 2010-11-19 18:06:33 +0100 (Fr, 19. Nov 2010) $
 * @revision $Revision: 52 $
 * @author $Author: toto $
 * @headurl $HeadURL: http://localhost/repos/teglo/administrator/components/com_tecox/install.tecox.php $
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

//$nPaths = $this->_paths;
$status = new JObject();
$status->modules = array();
$status->plugins = array();

/*
* +++++++++++++++++++++++++++++++++++++++++++++++++++
* Install of the modules parts
* +++++++++++++++++++++++++++++++++++++++++++++++++++
*/

$modules = &$this->manifest->getElementByPath('modules');
if (is_a($modules, 'JSimpleXMLElement') && count($modules->children())) {

	foreach ($modules->children() as $module)
	{
		$mname		= $module->attributes('module');
		$mclient	= JApplicationHelper::getClientInfo($module->attributes('client'), true);

		// Set the installation path
		if (!empty ($mname)) {
			$this->parent->setPath('extension_root', $mclient->path.DS.'modules'.DS.$mname);
		} else {
			$this->parent->abort(JText::_('Module').' '.JText::_('Install').': '.JText::_('No module file specified'));
			return false;
		}

		/*
		* If the module directory already exists, then we will assume that the
		* module is already installed or another module is using that directory.
		*/
		if (file_exists($this->parent->getPath('extension_root'))&&!$this->parent->getOverwrite()) {
			$this->parent->abort(JText::_('Module').' '.JText::_('Install').': '.JText::_('Another module is already using directory').': "'.$this->parent->getPath('extension_root').'"');
			return false;
		}

		// If the module directory does not exist, lets create it
		$created = false;
		if (!file_exists($this->parent->getPath('extension_root'))) {
			if (!$created = JFolder::create($this->parent->getPath('extension_root'))) {
				$this->parent->abort(JText::_('Module').' '.JText::_('Install').': '.JText::_('Failed to create directory').': "'.$this->parent->getPath('extension_root').'"');
				return false;
			}
		}

		/*
		* Since we created the module directory and will want to remove it if
		* we have to roll back the installation, lets add it to the
		* installation step stack
		*/
		if ($created) {
			           $this->parent->pushStep(array ('type' => 'folder', 'path' => $this->parent->getPath('extension_root')));
		              }

		// Copy all moules files
		$element = &$module->getElementByPath('files');
		if ($this->parent->parseFiles($element, -1) === false) {
			                                                    // Install failed, roll back changes
			                                                    $this->parent->abort();
			                                                    return false;
		                                                       }

		// Copy language files
		$element = &$module->getElementByPath('languages');
		if ($this->parent->parseLanguages($element, $mclient->id) === false) {
			                                                                  // Install failed, roll back changes
			                                                                  $this->parent->abort();
			                                                                  return false;
		                                                                     }

		$mtitle		= $module->attributes('title');
		$mposition	= $module->attributes('position');
		$morder		= $module->attributes('order');

		if ($mtitle && $mposition) {
			// if module already installed do not create a new instance
			$db =& JFactory::getDBO();
			$query = 'SELECT `id` FROM `#__modules` WHERE module = '.$db->Quote( $mname);
			$db->setQuery($query);
			if (!$db->Query()) {
				// Install failed, roll back changes
				$this->parent->abort(JText::_('Module').' '.JText::_('Install').': '.$db->stderr(true));
				return false;
			}
			$id = $db->loadResult();

			if (!$id){
				$row = & JTable::getInstance('module');
				$row->title		= $mtitle;
				$row->ordering	= $morder;
				$row->position	= $mposition;
				$row->showtitle	= 0;
				$row->iscore	= 0;
				$row->access	= ($mclient->id) == 1 ? 2 : 0;
				$row->client_id	= $mclient->id;
				$row->module	= $mname;
				$row->published	= 1;
				$row->params	= '';

				if (!$row->store()) {
					// Install failed, roll back changes
					$this->parent->abort(JText::_('Module').' '.JText::_('Install').': '.$db->stderr(true));
					return false;
				}
				
				// Make visible evertywhere if site module
				if ($mclient->id==0){
					$query = 'REPLACE INTO `#__modules_menu` (moduleid,menuid) values ('.$db->Quote( $row->id).',0)';
					$db->setQuery($query);
					if (!$db->query()) {
						// Install failed, roll back changes
						$this->parent->abort(JText::_('Module').' '.JText::_('Install').': '.$db->stderr(true));
						return false;
					}
				}


			}


		}

		$status->modules[] = array('name'=>$mname,'client'=>$mclient->name);
	}
}
/*
* 
* Install of the plugin parts
* 
*/

$plugins = &$this->manifest->getElementByPath('plugins');
if (is_a($plugins, 'JSimpleXMLElement') && count($plugins->children())) {

	foreach ($plugins->children() as $plugin)
	{
		$pname		= $plugin->attributes('plugin');
		$pgroup		= $plugin->attributes('group');
		$porder		= $plugin->attributes('order');

		// Set the installation path
		if (!empty($pname) && !empty($pgroup)) {
			$this->parent->setPath('extension_root', JPATH_ROOT.DS.'plugins'.DS.$pgroup);
		} else {
			$this->parent->abort(JText::_('Plugin').' '.JText::_('Install').': '.JText::_('No plugin file specified'));
			return false;
		}

		/**
		 * ---------------------------------------------------------------------------------------------
		 * Filesystem Processing Section
		 * ---------------------------------------------------------------------------------------------
		 */

		// If the plugin directory does not exist, lets create it
		$created = false;
		if (!file_exists($this->parent->getPath('extension_root'))) {
			if (!$created = JFolder::create($this->parent->getPath('extension_root'))) {
				$this->parent->abort(JText::_('Plugin').' '.JText::_('Install').': '.JText::_('Failed to create directory').': "'.$this->parent->getPath('extension_root').'"');
				return false;
			}
		}

		/*
		* If we created the plugin directory and will want to remove it if we
		* have to roll back the installation, lets add it to the installation
		* step stack
		*/
		if ($created) {
			$this->parent->pushStep(array ('type' => 'folder', 'path' => $this->parent->getPath('extension_root')));
		}

		// Copy all necessary files
		$element = &$plugin->getElementByPath('files');
		if ($this->parent->parseFiles($element, -1) === false) {
			// Install failed, roll back changes
			$this->parent->abort();
			return false;
		}

		/**
		 * ---------------------------------------------------------------------------------------------
		 * Database Processing Section
		 * ---------------------------------------------------------------------------------------------
		 */
		$db = &JFactory::getDBO();

		// Check to see if a plugin by the same name is already installed
		$query = 'SELECT `id`' .
		' FROM `#__plugins`' .
		' WHERE folder = '.$db->Quote($pgroup) .
		' AND element = '.$db->Quote($pname);
		$db->setQuery($query);
		if (!$db->Query()) {
			// Install failed, roll back changes
			$this->parent->abort(JText::_('Plugin').' '.JText::_('Install').': '.$db->stderr(true));
			return false;
		}
		$id = $db->loadResult();

		// Was there a plugin already installed with the same name?
		if ($id) {

			if (!$this->parent->getOverwrite())
			{
				// Install failed, roll back changes
				$this->parent->abort(JText::_('Plugin').' '.JText::_('Install').': '.JText::_('Plugin').' "'.$pname.'" '.JText::_('already exists!'));
				return false;
			}

		} else {
			$row =& JTable::getInstance('plugin');
			$row->name = 'Tecox - '.JText::_(ucfirst($pname));
			$row->ordering = $porder;
			$row->folder = $pgroup;
			$row->iscore = 0;
			$row->access = 0;
			$row->client_id = 0;
			$row->element = $pname;
			$row->published = 0;
			$row->params = '';

			if (!$row->store()) {
				// Install failed, roll back changes
				$this->parent->abort(JText::_('Plugin').' '.JText::_('Install').': '.$db->stderr(true));
				return false;
			}
		}

		$status->plugins[] = array('name'=>$pname,'group'=>$pgroup);
	}
	
	//store the standard values for the TCEdetails plugin
	$db = &JFactory::getDBO();
                                                                              
	$query = "SELECT ".$db->nameQuote('id')."		                 
              FROM ".$db->nameQuote('#__plugins')." 
              WHERE ".$db->nameQuote('element')." =  'tcedetails';";
    $db->setQuery($query);
    $result = $db->loadObject();                                                                 

	$query = "UPDATE #__plugins 
		      SET 
		        params='TCE_DETAILS_WITHOUT_SECTION_1=0\n
		                TCE_DETAILS_WITHOUT_SECTION_2=0\n
		                TCE_DETAILS_WITHOUT_SECTION_3=0\n
		                TCE_DETAILS_WITHOUT_SECTION_4=0\n
		                TCE_DETAILS_WITHOUT_CATEGORY_1=0\n
		                TCE_DETAILS_WITHOUT_CATEGORY_2=0\n
		                TCE_DETAILS_WITHOUT_CATEGORY_3=0\n
		                TCE_DETAILS_WITHOUT_CATEGORY_4=0\n
		                TCE_PLG_ART_BEFORETITLE=1\n
		                TCE_PLG_CSS_BEFORETITLE=CSS_BEFORETITLE\n
		                TCE_PLG_ART_BEFORETEXT=1\n
		                TCE_PLG_CSS_BEFORETEXT=CSS_BEFORETEXT\n
		                TCE_PLG_ART_AFTERTEXT=1\n
		                TCE_PLG_CSS_AFTERTEXT=CSS_AFTERTEXT\n
		                TCE_PLG_CSS_DIV=tce_plg_div\n
		                TCE_PLG_CSS_TITLE=tce_plg_title\n
		                TCE_PLG_TITLE_SHOW=1\n
		                TCE_PLG_TITLE_SIZE=3\n
		                TCE_PLG_HITS_DISPLAY=1\n
		                TCE_PLG_HITS_POS=4\n
		                TCE_PLG_HITS_IMG=-1\n
		                TCE_PLG_HITS_AVERAGE_DISPLAY=1\n
		                TCE_PLG_HITS_AVERAGE_PER_VALUE=month\n
		                TCE_PLG_HITS_AVERAGE_POS=4\n
		                TCE_PLG_HITS_AVERAGE_IMG=-1\n
		                TCE_PLG_LASTVISIT_DISPLAY=2\n
		                TCE_PLG_LASTVISIT_FORMAT=DATE_FORMAT_LC2\n
		                TCE_PLG_LASTVISIT_POS=4\n
		                TCE_PLG_LASTVISIT_IMG=-1\n
		                TCE_PLG_NUM_OF_WORDS_DISPLAY=1\n
		                TCE_PLG_NUM_OF_WORDS_POS=4\n
		                TCE_PLG_NUM_OF_WORDS_DISPLAY_IMG=-1\n
		                TCE_PLG_NUM_OF_CHARACTERS_DISPLAY=1\n
		                TCE_PLG_NUM_OF_CHARACTERS_POS=4\n
		                TCE_PLG_NUM_OF_CHARACTERS_DISPLAY_IMG=-1\n
		                TCE_PLG_VERSION_DISPLAY=0\n
		                TCE_PLG_VERSION_POS=4\n
		                TCE_PLG_VERSION_IMG=-1\n
		                TCE_PLG_CREATE_DISPLAY=3\n
		                TCE_PLG_CREATE_FORMAT=DATE_FORMAT_LC1\n
		                TCE_PLG_CREATE_POS=4\n
		                TCE_PLG_CREATE_IMG=-1\n
		                TCE_PLG_MODIFICATION_DISPLAY=3\n
		                TCE_PLG_MODIFICATION_FORMAT=DATE_FORMAT_LC1\n
		                TCE_PLG_MODIFICATION_POS=4\n
		                TCE_PLG_MODIFICATION_IMG=-1\n
		                TCE_PLG_PUBLISHUP_DISPLAY=0\n
		                TCE_PLG_PUBLISHUP_FORMAT=DATE_FORMAT_LC1\n
		                TCE_PLG_PUBLISHUP_POS=4\n
		                TCE_PLG_PUBLISHUP_IMG=-1\n
		                TCE_PLG_PUBLISHDOWN_DISPLAY=0\n
		                TCE_PLG_PUBLISHDOWN_FORMAT=DATE_FORMAT_LC1\n
		                TCE_PLG_PUBLISHDOWN_POS=4\n
		                TCE_PLG_PUBLISHDOWN_IMG=-1\n
		                TCE_PLG_ITEMID_DISPLAY=0\n
		                TCE_PLG_ITEMID_POS=4\n
		                TCE_PLG_ITEMID_IMG=-1\n\n'  
		      WHERE 
		        id='".$result->id."'";
	 $db->setQuery( $query );
	 $db->query();
	 $load_standard_TCEdetails = "Standard data has been written into the Plugin with ID: ".$result->id;
     //store the standard values for the TCEtypo plugin
                                                                              
	 $query = "SELECT ".$db->nameQuote('id')."		                 
               FROM ".$db->nameQuote('#__plugins')." 
               WHERE ".$db->nameQuote('element')." =  'tcetypo';";
     $db->setQuery($query);
     $result = $db->loadObject();                                                                 

	 $query = "UPDATE #__plugins 
		       SET 
		         params='TCE_TYPO_WITHOUT_SECTION_1=0\n
		                 TCE_TYPO_WITHOUT_SECTION_2=0\n
		                 TCE_TYPO_WITHOUT_SECTION_3=0\n
		                 TCE_TYPO_WITHOUT_SECTION_4=0\n
		                 TCE_TYPO_WITHOUT_CATEGORY_1=0\n
		                 TCE_TYPO_WITHOUT_CATEGORY_2=0\n
		                 TCE_TYPO_WITHOUT_CATEGORY_3=0\n
		                 TCE_TYPO_WITHOUT_CATEGORY_4=0\n\n'  
		       WHERE 
		         id='".$result->id."'";
	  $db->setQuery( $query );
	  $db->query();	 
	  $load_standard_TCEtypo = "Standard data has been written into the Plugin with ID: ".$result->id;
	  //store the standard values for the TCEsocial plugin
                                                                              
	 $query = "SELECT ".$db->nameQuote('id')."		                 
               FROM ".$db->nameQuote('#__plugins')." 
               WHERE ".$db->nameQuote('element')." =  'tcesocial';";
     $db->setQuery($query);
     $result = $db->loadObject();                                                                 

	 $query = "UPDATE #__plugins 
		       SET 
		         params='TCE_SOCIAL_WITHOUT_SECTION_1=0\n
		                 TCE_SOCIAL_WITHOUT_SECTION_2=0\n
		                 TCE_SOCIAL_WITHOUT_SECTION_3=0\n
		                 TCE_SOCIAL_WITHOUT_SECTION_4=0\n
		                 TCE_SOCIAL_WITHOUT_CATEGORY_1=0\n
		                 TCE_SOCIAL_WITHOUT_CATEGORY_2=0\n
		                 TCE_SOCIAL_WITHOUT_CATEGORY_3=0\n
		                 TCE_SOCIAL_WITHOUT_CATEGORY_4=0\n
		                 TCE_PLG_FB_LIKE_BUTTON_API=No\n
		                 TCE_PLG_FB_POS=4\n
		                 TCE_PLG_FB_STYLE=standard\n
		                 TCE_PLG_FB_DISPLAY=like\n
		                 TCE_PLG_FB_SCHEME=light\n
		                 TCE_PLG_FB_FONT=arial\n
		                 TCE_PLG_FB_FACES=true\n
		                 TCE_PLG_FB_LIKE_WIDTH=450\n
		                 TCE_PLG_TWITTER_BUTTON_API=No\n
		                 TCE_PLG_TWITTER_POS=4\n
		                 TCE_PLG_TWITTER_STYLE=horizontal\n
		                 TCE_PLG_GBUZZ_BUTTON_API=No\n
		                 TCE_PLG_GBUZZ_POS=4\n
		                 TCE_PLG_GBUZZ_STYLE=small-count\n
		                 TCE_PLG_GBUZZ_IMG=-1\n
		                 TCE_PLG_YBUZZ_BUTTON_API=No\n
		                 TCE_PLG_YBUZZ_POS=4\n
		                 TCE_PLG_YBUZZ_STYLE=small\n
		                 TCE_PLG_YBUZZ_COUNTER=-votes\n
		                 TCE_PLG_YBUZZ_CAT=business\n
		                 TCE_PLG_REDDIT_BUTTON_API=No\n
		                 TCE_PLG_REDDIT_POS=4\n
		                 TCE_PLG_REDDIT_STYLE=3\n
		                 TCE_PLG_REDDIT_BORDERCOLOR=888888\n
		                 TCE_PLG_REDDIT_BGCOLOR=FFFFFF\n
		                 TCE_PLG_DIGG_BUTTON_API=No\n
		                 TCE_PLG_DIGG_POS=4\n
		                 TCE_PLG_DIGG_STYLE=DiggIcon\n
		                 TCE_PLG_DIGG_CAT=business\n\n'  
		       WHERE 
		         id='".$result->id."'";
	  $db->setQuery( $query );
	  $db->query();	 
	  $load_standard_TCEsocial = "Standard data has been written into the Plugin with ID: ".$result->id;
}
/*
* Displaying install results
*/
$rows = 0;
?>
<img src="components/com_tecox/images/x-logo_48x48.png" width="48" height="48" alt="Tecox X-logo" align="right" />
<h2>Installation</h2>
Thank you for installing the Tecox component. 
<table class="adminlist">
	<thead>
		<tr>
			<th class="title" colspan="2"><?php echo JText::_('Extension'); ?></th>
			<th width="30%"><?php echo JText::_('Status'); ?></th>
		</tr>
	</thead>
	<tfoot>
		<tr>
			<td colspan="3"></td>
		</tr>
	</tfoot>
	<tbody>
		<tr class="row0">
			<td class="key" colspan="2"><?php echo 'Tecox '.JText::_('Component'); ?></td>
			<td><strong><?php echo JText::_('Installed'); ?></strong></td>
		</tr>
<?php if (count($status->modules)) : ?>
		<tr>
			<th><?php echo JText::_('Module'); ?></th>
			<th><?php echo JText::_('Client'); ?></th>
			<th></th>
		</tr>
	<?php foreach ($status->modules as $module) : ?>
		<tr class="row<?php echo (++ $rows % 2); ?>">
			<td class="key"><?php echo $module['name']; ?></td>
			<td class="key"><?php echo ucfirst($module['client']); ?></td>
			<td><strong><?php echo JText::_('Installed'); ?></strong></td>
		</tr>
	<?php endforeach;
	endif;
if (count($status->plugins)) : ?>
		<tr>
			<th><?php echo JText::_('Plugin'); ?></th>
			<th><?php echo JText::_('Group'); ?></th>
			<th></th>
		</tr>
	<?php foreach ($status->plugins as $plugin) : ?>
		<tr class="row<?php echo (++ $rows % 2); ?>">
			<td class="key"><?php echo ucfirst($plugin['name']); ?></td>
			<td class="key"><?php echo ucfirst($plugin['group']); ?></td>
			<td><strong><?php echo JText::_('Installed'); ?></strong></td>
		</tr>
		<?php endforeach; ?>
	      <tr class="row0">
			<td class="key"><?php echo $load_standard_TCEdetails ?></td>
			<td class="key">Plugin - Content</td>
			<td><strong><?php echo JText::_('Installed'); ?></strong></td>
		</tr>
		<tr class="row0">
			<td class="key"><?php echo $load_standard_TCEtypo ?></td>
			<td class="key">Plugin - Content</td>
			<td><strong><?php echo JText::_('Installed'); ?></strong></td>
		</tr>
		<tr class="row0">
			<td class="key"><?php echo $load_standard_TCEsocial ?></td>
			<td class="key">Plugin - Content</td>
			<td><strong><?php echo JText::_('Installed'); ?></strong></td>
		</tr>
<?php endif; ?> 
	</tbody>
</table>
