<?php
/**
 * @package Joomla 1.5.x
 * @copyright	Copyright (C) 2005 - 2010 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant to the
 * GNU General Public License, and as distributed it includes or is derivative
 * of works licensed under the GNU General Public License or other free or open
 * source software licenses. See COPYRIGHT.php for copyright notices and
 * details.
 *
 * @module Tecox
 * @copyright Copyright (C) 2010 by www.teglo.info
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @date $Date: 2010-11-18 08:57:19 +0100 (Do, 18. Nov 2010) $
 * @revision $Revision: 49 $
 * @author $Author: toto $
 * @headurl $HeadURL: http://localhost/repos/teglo/modules/mod_tcelastvisit/helper.php $
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

require_once (JPATH_SITE.DS.'components'.DS.'com_content'.DS.'helpers'.DS.'route.php');

class modTceLastVisitHelper
                          {
	                       function getList(&$params)
	                                                 {
		                                              global $mainframe;

		                                              $db =& JFactory::getDBO();
		                                              $user	=& JFactory::getUser();

		                                              $count = intval($params->get('count', 5));
		                                              $catid = trim($params->get('catid'));
		                                              $secid = trim($params->get('secid'));
		                                              $aid = $user->get('aid', 0);

		                                              $contentConfig = &JComponentHelper::getParams( 'com_content' );
		                                              $access = !$contentConfig->get('show_noauth');

		                                              $nullDate	= $db->getNullDate();
		                                              $date =& JFactory::getDate();
		                                              $now  = $date->toMySQL();
		                                              
	                                                  if ($catid) {
			                                                       $ids = explode( ',', $catid );
			                                                       JArrayHelper::toInteger( $ids );
			                                                       $catCondition = ' AND (cc.id=' . implode( ' OR cc.id=', $ids ) . ')';
		                                                          }
		                                              if ($secid) {
			                                                       $ids = explode( ',', $secid );
			                                                       JArrayHelper::toInteger( $ids );
			                                                       $secCondition = ' AND (s.id=' . implode( ' OR s.id=', $ids ) . ')';
		                                                          }

		                                              //Check if some datas available
		                                              
                                                      $query = 'SELECT COUNT(*)'
		                                                    . ' FROM #__tecox_lastvisit';
		                                              $db->setQuery( $query );
		                                              
		                                              //For to get only this numbers of records, how to exist
	                                                  if ($db->loadResult() < $count) {
                                                                                       $count = $db->loadResult();
                                                                                      }
		                                              if ($db->loadResult() == 0) {
		                                              	                           return null;
		                                                                          }
		                                              else {
                                                            //Get content Items for last visit entries
                                                            $query = ' SELECT a.* ' .		                 
                                                                     ' FROM #__content AS a' .
                                                                     ' LEFT JOIN #__tecox_lastvisit AS lv ON lv.item_id = a.id' .
                                                                     ' INNER JOIN #__categories AS cc ON cc.id = a.catid' .
	 	                                                             ' INNER JOIN #__sections AS s ON s.id = a.sectionid' .
                                                                     ' WHERE ( a.state = 1 AND s.id > 0 )' .
			                                                              ' AND ( a.publish_up = '.$db->Quote($nullDate).' OR a.publish_up <= '.$db->Quote($now).' )' .
			                                                              ' AND ( a.publish_down = '.$db->Quote($nullDate).' OR a.publish_down >= '.$db->Quote($now).' )'.
			                                                              ($access ? ' AND a.access <= ' .(int) $aid. ' AND cc.access <= ' .(int) $aid. ' AND s.access <= ' .(int) $aid : '').
			                                                              ($catid ? $catCondition : '').
			                                                              ($secid ? $secCondition : ''). 
                                                                     ' ORDER BY lv.datetime DESC, a.title ASC ';
	
		                                                    $db->setQuery($query, 0, $count);
		                                                    $rows = $db->loadObjectList();

		                                                    $i = 0;
		                                                    $lists = array();
		                                                    foreach ( $rows as $row )
	                                                                           	     {
			                                                                          if($row->access <= $aid)
			                                                                                            {
				                                                                                         $lists[$i]->link = JRoute::_(ContentHelperRoute::getArticleRoute($row->id, $row->catslug, $row->sectionid));
			                                                                                            } 
			                                                                    else {
				                                                                      $lists[$i]->link = JRoute::_('index.php?option=com_user&view=login');
			                                                                         }
			                                                                    $lists[$i]->text = htmlspecialchars( $row->title );
			                                                                    if ($params->get('show_hits', 1) == 1) {
			                                                                    	                                    $lists[$i]->hits = ' ('.$row->hits.')';
			                                                                                                           }			                                                                    
			                                                                    $lists[$i]->item_id = $row->id;
			                                                                    if ($params->get('show_distance', 1) == 1) {
			                                                                                                                $lists[$i]->datetime = "<br />".JText::_('TCE_MOD_LASTVISIT_FIRST')." ".modTceLastVisitHelper::DatabaseGetDatetime($row->id)." ".JText::_('TCE_MOD_LASTVISIT_SECOND');
			                                                                                                               }
			                                                                    $i++;
		                                                                       }
		                                                   }

		                                              return $lists;
	                                                 }	                                                
                           function DatabaseGetDatetime ($Item_id) {
                           	                                        $db = &JFactory::getDBO();
                                                                    $query = "SELECT ".$db->nameQuote('item_id').",".$db->nameQuote('datetime')."		                 
                                                                              FROM ".$db->nameQuote('#__tecox_lastvisit')." 
                                                                              WHERE ".$db->nameQuote('item_id')." = ".$Item_id.";";
		                                                            $db->setQuery($query);
		                                                            $result = $db->loadObject(); 
		                                                            
		                                                            //create Timestamp with user timezone
		                                                            $lv_timestamp = strtotime($result->datetime) + modTceLastVisitHelper::TimezoneSetting() - modTceLastVisitHelper::TimezoneServer();
		                                                            $lv_value = date("Y-m-d H:i:s",$lv_timestamp);
		                                                            
		                                                            return modTceLastVisitHelper::AgeOfArticle(
		                                                                                                       substr($lv_value,8,2),
		                                                                                                       substr($lv_value,5,2),
		                                                                                                       substr($lv_value,0,4),
		                                                                                                       substr($lv_value,11,8)
		                                                                                                      );
                                                                   }                                                   
                           function MonthsAndDaysCounter ($day, 
                                                          $month, 
                                                          $year, 
                                                          $value) {
	                                                                              $sum_month = 0;
		                                                                          $number_days_per_month = 0;
		                                                                          $numbers_of_days_per_month = 0;
		                                                                   
		                                                                          for ($year_counter=$year; 
		                                                                               $year_counter<=date("Y",modTceLastVisitHelper::UserTimestamp()); 
		                                                                               $year_counter++)
		                                                                                               {
		      	                                                                                        if ($year_counter == $year 
		      	                                                                                         && $year_counter != date("Y",modTceLastVisitHelper::UserTimestamp())) {
		      	                                                             	                                                                         //Number of month of the first year *****************************************
		      	                                                             	                                                                         for ($month_counter=$month+1; 
		      	                                                             	                                                                              $month_counter<=12; 
		      	                                                             	                                                                              $month_counter++)
		      	                                           	                                                                                                                   {
		      	                                           	                                                                                                                    $sum_month = $sum_month +1;
		      	                                           	                                                                                                                    $calc_num_day = mktime(0, 0, 0, $month_counter, 1, $year_counter);
		      	                                                             	                                                                                                $number_days_per_month = $number_days_per_month + date("t", $calc_num_day);
		      	                                                             	                                                                                               }
		      	                                                                                                                                        }	
		      	                                                                                        elseif ($year_counter >= $year 
		      	                                                                                             && $year_counter != date("Y",modTceLastVisitHelper::UserTimestamp())) {
		      	                                                             	                                                                             //Number of month for the next years *****************************************************
		      	                                                             	                                                                             for ($month_counter=1; 
		      	                                                             	                                                                                  $month_counter<=12; 
		      	                                                             	                                                                                  $month_counter++)
		      	                                           	                                                                                                                       {
		      	                                           	                                                                                                                        $sum_month = $sum_month +1;
		      	                                           	                                                                                                                        $calc_num_day = mktime(0, 0, 0, $month_counter, 1, $year_counter);
		      	                                                             	                                                                                                    $number_days_per_month = $number_days_per_month + date("t", $calc_num_day);
		      	                                           	  	                                                                                                                   }
		      	                                                                                                                                            }
		      	                                                                                        elseif ($year_counter == date("Y",modTceLastVisitHelper::UserTimestamp ()) 
		      	                                                                                             && $year != date("Y",modTceLastVisitHelper::UserTimestamp())) {
		      	                                                             	                                                                     //Numbers of months for the last year ***************************************
		      	                                                             	                                                                     for ($month_counter=1; 
		      	                                                             	                                                                          $month_counter<=date("m",modTceLastVisitHelper::UserTimestamp()); 
		      	                                                             	                                                                          $month_counter++)
		      	                                           	                                                                                                               {
		      	                                           	                                                                                                                $sum_month = $sum_month +1;
		      	                                           	                                                                                                                $calc_num_day = mktime(0, 0, 0, $month_counter, 1, $year_counter);
		      	                                                             	                                                                                            $number_days_per_month = $number_days_per_month + date("t", $calc_num_day);
		      	                                           	  	                                                                                                           }
		      	                                                                                                                                    }
		      	                                                                                        else {
		      	                                                             	                              //If only one year
		      	                                                             	                              $numbers_of_days_per_month = 0;
		      	                                                             	                              for ($month_counter=$month; 
		      	                                                             	                                   $month_counter<=date("m",modTceLastVisitHelper::UserTimestamp()); 
		      	                                                             	                                   $month_counter++)
		      	                                           	                                                                        {
		      	                                           	                                                                         $sum_month = $sum_month +1;
		      	                                           	                                                                         $calc_num_day = mktime(0, 0, 0, $month_counter, 1, $year_counter);
		      	                                           	                                                                         if ($sum_month == 1 
		      	                                           	                                                                          && $month != date("m",modTceLastVisitHelper::UserTimestamp())){
		      	                                           	                                                          	                                                      //Days of the frist month****************************************************
		      	                                           	                                                          	                                                      $numbers_of_days_per_month = date("t", $calc_num_day) - $day;
		      	                                           	                                                        	                                                     }
		      	                                           	                                                                         elseif ($sum_month == 1 
		      	                                           	                                                                              && $month == date("m",modTceLastVisitHelper::UserTimestamp())){
		      	                                           	                                                                                             	                      //Days of the frist month****************************************************
		      	                                           	                                                                                             	                      $numbers_of_days_per_month = date("d",modTceLastVisitHelper::UserTimestamp()) - $day;
		      	                                           	                                                                                             	                     }	                                           	                                                                                             	                                       
		      	                                           	                                                                         elseif ($month_counter<=date("m",modTceLastVisitHelper::UserTimestamp())) {
		      	                                           	                                                                                             	                             //Days of last month****************************************************
		      	                                           	                                                                                             	                             $numbers_of_days_per_month = $numbers_of_days_per_month + date("d",modTceLastVisitHelper::UserTimestamp());
		      	                                           	                                                                                             	                            }
		      	                                           	                                                                         else {
		      	                                           	                                                                               //Days of a complete month*******************************************************************
		      	                                           	                                                                               $calc_num_day = mktime(0, 0, 0, $month_counter, 1, $year_counter);
		      	                                                             	                                                           $numbers_of_days_per_month = $numbers_of_days_per_month + date("t", $calc_num_day);
		      	                                                             	                                                          }
		      	                                           	                                                                        } 
		      	                                                                                             }                                                            
	                                                                                                   }
	                                                                              if ($value == "days") {
	                                                                                                     return $numbers_of_days_per_month;	                                                              
	                                                                                                    }
	                                                                              elseif ($value == "months") {
	                                        	                                                               return $sum_month;
	                                        	                                                              }
	                                                                              elseif ($value == "years") {	                 
	                                        	                                                              return floor($sum_month/12);	                                        	                        
	                                        	                                                             }
	                                                                              else {
	                                        	                                        return JText::_( 'TCE_PLG_ERROR_AVERAGE' );
	                                                                                   }
	                                                              }
	                      function AgeOfArticle ($day_distance,
	                                             $month_distance,
	                                             $year_distance, 
	                                             $time_art) { 
		                                                                     //just for testing the AgeOfArticle function
		                                                                     //$day_distance=12;
		                                                                     //$month_distance=6;
		                                                                     //$year_distance=2010;
		                                                                     //$time_art="7:22";
		                                                                     //--------------------------------------------------------------------                  
		                                                                     // result of the age of the article **************************************************************************************************************************************************************************************************************
   	                                                                         $config = & JFactory::getConfig();
   	                                                                        //$plural_hours_minArray = Array("/x/");
   	                                                                                
   	                                                                         $plural_hours_minArray = Array("/10 ".JText::_( 'TCE_PLG_DISTANCE_HOURS' )." ".JText::_( 'TCE_PLG_DISTANCE_AND' )."/",
   	                                                                                                        "/11 ".JText::_( 'TCE_PLG_DISTANCE_HOURS' )." ".JText::_( 'TCE_PLG_DISTANCE_AND' )."/",
   	                                                                                                        "/20 ".JText::_( 'TCE_PLG_DISTANCE_HOURS' )." ".JText::_( 'TCE_PLG_DISTANCE_AND' )."/",
   	                                                                                                        "/21 ".JText::_( 'TCE_PLG_DISTANCE_HOURS' )." ".JText::_( 'TCE_PLG_DISTANCE_AND' )."/",
   	                                                                                                        "/0 ".JText::_( 'TCE_PLG_DISTANCE_HOURS' )." ".JText::_( 'TCE_PLG_DISTANCE_AND' )."/",
   	                                                                                                        "/00 ".JText::_( 'TCE_PLG_DISTANCE_HOURS' )."/",
   	                                                                                                        "/1 ".JText::_( 'TCE_PLG_DISTANCE_HOURS' )." ".JText::_( 'TCE_PLG_DISTANCE_AND' )."/",
   	                                                                                                              );
                                                                             $plural_hours_min_replace_Array = Array("10 ".JText::_( 'TCE_PLG_DISTANCE_HOURS' ),
                                                                                                                     "11 ".JText::_( 'TCE_PLG_DISTANCE_HOURS' ),
                                                                                                                     "20 ".JText::_( 'TCE_PLG_DISTANCE_HOURS' ),
                                                                                                                     "21 ".JText::_( 'TCE_PLG_DISTANCE_HOURS' ),
                                                                                                                     " ",
                                                                                                                     " ",
                                                                                                                     " ".JText::_( 'TCE_PLG_DISTANCE_ONEHOURS' ),
                                                                                                                    );
                                                                                 
		                                                                     $plural_mon_yearArray = Array("/10 ".JText::_( 'TCE_PLG_DISTANCE_YEARS' )." ".JText::_( 'TCE_PLG_DISTANCE_AND' )." 0 ".JText::_( 'TCE_PLG_DISTANCE_MONTHS' )."/",
		                                                                                                   "/10 ".JText::_( 'TCE_PLG_DISTANCE_YEARS' )."/",
		                                                                                                   "/11 ".JText::_( 'TCE_PLG_DISTANCE_YEARS' )." ".JText::_( 'TCE_PLG_DISTANCE_AND' )." 0 ".JText::_( 'TCE_PLG_DISTANCE_MONTHS' )."/",
		                                                                                                   "/11 ".JText::_( 'TCE_PLG_DISTANCE_YEARS' )."/",
		                                                                                                   "/1 ".JText::_( 'TCE_PLG_DISTANCE_YEARS' )."/",
		                                                                                                   "/1 ".JText::_( 'TCE_PLG_DISTANCE_MONTHS' )."/");
                                                                             $plural_mon_year_replace_Array = Array("10&nbsp;".JText::_( 'TCE_PLG_DISTANCE_YEARS' ), 
                                                                                                                    "11&nbsp;".JText::_( 'TCE_PLG_DISTANCE_YEARS' ),
                                                                                                                    "11&nbsp;".JText::_( 'TCE_PLG_DISTANCE_YEARS' ),  
                                                                                                                    " ".JText::_( 'TCE_PLG_DISTANCE_ONEYEAR' ),                                                                                                                    
                                                                                                                    " ".JText::_( 'TCE_PLG_DISTANCE_ONEMONTH' ));
                                                                                    
   	                                                                         $start_time = strtotime($year_distance."-".$month_distance."-".$day_distance." ".$time_art); 
                                                                                    
                                                                             $start_time = $start_time + modTceLastVisitHelper::TimezoneServer(); //Date and time stamp with Timezone correction
                                                                             $current_time = modTceLastVisitHelper::UtcTimestamp() + modTceLastVisitHelper::TimezoneSetting(); //Current date and time stamp with UTC server correction
                                                                             $diff_time = $current_time - $start_time;
         
		                                                                     if (modTceLastVisitHelper::MonthsAndDaysCounter($day_distance,$month_distance,$year_distance,"months") <= 2 
		                                                                      && modTceLastVisitHelper::MonthsAndDaysCounter($day_distance,$month_distance,$year_distance,"days") >= 2) {
		                                            	                                                                                                          return " ".modTceLastVisitHelper::MonthsAndDaysCounter($day_distance,$month_distance,$year_distance,"days")." ".JText::_( 'TCE_PLG_DISTANCE_DAYS' );
		      	                                                                                                                                                 }
		                                                                     elseif (modTceLastVisitHelper::MonthsAndDaysCounter($day_distance,$month_distance,$year_distance,"months") <= 2 
		                                                                          && modTceLastVisitHelper::MonthsAndDaysCounter($day_distance,$month_distance,$year_distance,"days") == 0 
		                                                                          || modTceLastVisitHelper::MonthsAndDaysCounter($day_distance,$month_distance,$year_distance,"days") == 1 
		                                                                          && $diff_time <= 86400) {
		 	                                                                                               // diff_time = 60s = 1Mnin, and so on...  
		 	                                                                                               //self day
		 	                                                                                               if ($diff_time <= 120) {
		                                                              	                                                           return " ".JText::_( 'TCE_PLG_DISTANCE_ONEMINUTE' );
		                                                                                                                          }
		                                                                                                   elseif ($diff_time >= 121 ) { 
		                                                              	                                                                $result_hour_min = floor($diff_time/3600)." ".JText::_( 'TCE_PLG_DISTANCE_HOURS' )." ".JText::_( 'TCE_PLG_DISTANCE_AND' )." ".floor($diff_time/60-floor($diff_time/3600)*60)." ".JText::_( 'TCE_PLG_DISTANCE_MINUTES' );
		                                                              	                                                                return $result_hour_min = preg_replace($plural_hours_minArray ,  $plural_hours_min_replace_Array , $result_hour_min);
		                                                              	                                                                //ohne Korrektur
		                                                              	                                                                //return $result_hour_min;
		                                                                                                                               }
		                                                                                                  } 
                                                                             elseif (modTceLastVisitHelper::MonthsAndDaysCounter($day_distance,$month_distance,$year_distance,"months") <= 2 
                                                                                  && modTceLastVisitHelper::MonthsAndDaysCounter($day_distance,$month_distance,$year_distance,"days") == 1) {
         	                                                                                                                                                          // Next 2 Days after article created	      	                                           	                                       
		                                                                                                                                                              $result_hour_min = " ".JText::_( 'TCE_PLG_DISTANCE_ONEDAY' )." ".JText::_( 'TCE_PLG_DISTANCE_AND' )." ".gmstrftime('%H '.JText::_( 'TCE_PLG_DISTANCE_HOURS' ).' %M '.JText::_( 'TCE_PLG_DISTANCE_MINUTES' ), $diff_time);
		                                                                                                                                                              return $result_hour_min = preg_replace($plural_hours_minArray ,  $plural_hours_min_replace_Array , $result_hour_min);
		                                                                                                                                                             }		                                           
		                                                                     elseif (modTceLastVisitHelper::MonthsAndDaysCounter($day_distance,$month_distance,$year_distance,"months") == 12) {
		 		 	                                                                                                                                                     return " ".JText::_( 'TCE_PLG_DISTANCE_ONEYEAR' );
		                                                                                                                                                                }
		                                                                     elseif (modTceLastVisitHelper::MonthsAndDaysCounter($day_distance,$month_distance,$year_distance,"months") > 12) {
		 	                                                                                                                                                            $numbers_of_years = floor(modTceLastVisitHelper::MonthsAndDaysCounter($day_distance,$month_distance,$year_distance,"months") / 12); //immer auf ganze Zahl abgerundet! 
		 	                                                                                                                                                            $numbers_of_rest_month = modTceLastVisitHelper::MonthsAndDaysCounter($day_distance,$month_distance,$year_distance,"months") - 12*$numbers_of_years; //Berechnung der Restmonate zum vollem Jahr hin
		 	                                                                                                                                                            $result_mon_year = $numbers_of_years." ".JText::_( 'TCE_PLG_DISTANCE_YEARS' )." ".JText::_( 'TCE_PLG_DISTANCE_AND' )." ".$numbers_of_rest_month." ".JText::_( 'TCE_PLG_DISTANCE_MONTHS' );
		 	                                                                                                                                                            return $result_mon_year = preg_replace($plural_mon_yearArray ,  $plural_mon_year_replace_Array , $result_mon_year);
		 	                                                                                                                                                           }
		                                                                     else {
		                                                                           return " ".modTceLastVisitHelper::MonthsAndDaysCounter($day_distance,$month_distance,$year_distance,"months")." ".JText::_( 'TCE_PLG_DISTANCE_MONTHSAGO' );
		                                                                          }
	                                                                        }                                          
/** 
 * ----------------------------------------------------------------------------------
 * Functions for Time and Date settings 
 * ----------------------------------------------------------------------------------
 */                                                                                        
                                          function TimezoneSetting () {
                                                                       $config = & JFactory::getConfig();
                                                                       $joomla_timezone_setting = $config->getValue('config.offset')*3600;

                                                                       if(isset($_COOKIE["usertimezone"])) {
	                                                                                                       //Gets Timezone factor from User Browser as a cookie entry
	                                                                                                       //The timezone will be returned as timestamp 
                                                                                                           return $_COOKIE["usertimezone"]*3600;
                                                                                                           }
                                                                       else {
                                                                             $config = & JFactory::getConfig();
                                                                             //If cookie doen't exsist, it will returned the timezone factor from the web server
                                                                             return $joomla_timezone_setting;
                                                                            }
                                                                      }
                                          function TimezoneServer () {
	                                                                 //Timezone setting from the websever in Joomla as timestamp
                                                                     $config = & JFactory::getConfig();
                                                                     return $config->getValue('config.offset')*3600;                            
                                                                     }
                                          function UtcTimestamp () {
	                                                               //Timestamp as UTC
	                                                               $config = & JFactory::getConfig();
                                                                   $joomla_timezone_setting = $config->getValue('config.offset')*3600;
	                                                               return time() - $joomla_timezone_setting;
                                                                   }
                                          function UserTimestamp () {
	                                                                //Current Timestamp for the User, if cookie exsist. Otherwise it will returned the normal timestamp value, the same like time() value. 
	                                                                return modTceLastVisitHelper::UtcTimestamp() + modTceLastVisitHelper::TimezoneSetting();
                                                                    }
                                                                                                             
	                                                                                            

                          }
